﻿/*  Author:     Ben Hall
 *  File:       NPCEvent.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    NPCEvent.cs extends the MapEvent Class and is used for showing interactions with
 *              NPCs such as dialog, quest giving, and shopping.
 *              
 *              Currently only the Shop features are used in the game.
 */

using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;

namespace OnlineGame
{
    public enum NPCEventType { Dialog, Quest, Shop }

    public class NPCEvent : MapEvent
    {
        private NPCEventType eventType;
        private String NPCName;
        private BitmapImage NPCPortrait;
        private String[] dialog;

        //for Shop types
        private float shopPriceIncrease;  //standard value is 2.0 but may be higher
        private Item[] itemInventory;
        private Equipment[] equipmentInventory;

        public NPCEvent(NPCEventType eventTypeIn, String NPCNameIn, BitmapImage portraitIn, String[] dialogIn)
        {
            this.eventType = eventTypeIn;
            this.dialog = dialogIn;
            this.NPCName = NPCNameIn;
            this.NPCPortrait = portraitIn;
        }

        public NPCEventType GetNPCEventType()
        {
            return this.eventType;
        }

        public void SetItemInventory(Item[] inventoryIn)
        {
            this.itemInventory = inventoryIn;
        }
        public Item[] GetItemInventory()
        {
            return this.itemInventory;
        }

        public void SetEquipmentInventory(Equipment[] inventoryIn)
        {
            this.equipmentInventory = inventoryIn;
        }
        public Equipment[] GetEquipmentInventory()
        {
            return this.equipmentInventory;
        }

        public BitmapImage GetNPCPortrait()
        {
            return this.NPCPortrait;
        }

        public String GetNPCName()
        {
            return this.NPCName;
        }

        public String[] GetNPCDialog()
        {
            return this.dialog;
        }

        public float GetShopPriceIncrease()
        {
            return this.shopPriceIncrease;
        }

        public void SetShopPriceIncrease(float increaseIn)
        {
            this.shopPriceIncrease = increaseIn;
        }
    }
}